unit PPSaver_SetPropertiesProgrammatically_;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, PPSaver, ExtCtrls, ComCtrls;

type
  TfrmDemo = class(TForm)
    Label4: TLabel;
    StatusBar1: TStatusBar;
    PropertyPageSaver: TPropertyPageSaver;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    btnShowGlobal: TButton;
    btnShowIdentification: TButton;
    Label1: TLabel;
    Label2: TLabel;
    TabSheet3: TTabSheet;
    Label3: TLabel;
    Label5: TLabel;
    btnActivate: TButton;
    btnDeactivate: TButton;
    Label8: TLabel;
    GroupBox1: TGroupBox;
    tbrFilmEffect: TTrackBar;
    Label6: TLabel;
    Label7: TLabel;
    btnDialog: TButton;
    mmoResults: TMemo;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    procedure btnShowGlobalClick(Sender: TObject);
    procedure PropertyPageSaverPropertiesRestored(Sender: TObject);
    procedure PropertyPageSaverPropertiesSaved(Sender: TObject);
    procedure btnShowIdentificationClick(Sender: TObject);
    procedure btnActivateClick(Sender: TObject);
    procedure tbrFilmEffectChange(Sender: TObject);
    procedure btnDialogClick(Sender: TObject);
    procedure btnDeactivateClick(Sender: TObject);
    procedure TabSheet3Show(Sender: TObject);
    procedure PropertyPageSaverNewPropertyValue(Sender: TObject;
      PropertyId, PropertyValue, PropertyLabel: String);
  private
  public
  end;

var
  frmDemo: TfrmDemo;

implementation

uses ActiveX, ComObj;

{$R *.DFM}

const
    CLSID_DIVX: TGUID = '{78766964-0000-0010-8000-00AA00389B71}';
    DIVX_V52_INTERFACE_VERSION = 3125745154;
    DIVX_FILMEFFECT_ID = '017011';

//------------------------------------------------------------------------------
procedure TfrmDemo.btnActivateClick(Sender: TObject);
//------------------------------------------------------------------------------
var
   pUnk: IUnknown;
begin
   if CoCreateInstance (CLSID_DIVX, nil, CLSCTX_INPROC_SERVER or CLSCTX_LOCAL_SERVER, IUnknown, pUnk) = S_OK then begin
      if PropertyPageSaver.Activate (pUnk) then begin
         if PropertyPageSaver.GetInterfaceVersion = DIVX_V52_INTERFACE_VERSION then begin
            PropertyPageSaver.RestoreProperties;
            btnActivate.Enabled := False;
            btnDialog.Enabled := True;
            btnDeActivate.Enabled := True;
            tbrFilmEffect.Position := StrToIntDef (PropertyPageSaver.GetProperty (DIVX_FILMEFFECT_ID), 0);
         end
         else begin
            mmoResults.Lines.Add ('Interface version error: DivX v5.2 required');
         end;
      end;
      pUnk := nil;
   end;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.btnDialogClick(Sender: TObject);
//------------------------------------------------------------------------------
begin
   if PropertyPageSaver.ShowDialog then begin // button OK pressed
      PropertyPageSaver.SaveProperties;
   end;
   tbrFilmEffect.Position := StrToIntDef (PropertyPageSaver.GetProperty (DIVX_FILMEFFECT_ID), 0); // we refresh the trackbar
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.tbrFilmEffectChange(Sender: TObject);
//------------------------------------------------------------------------------
begin
   PropertyPageSaver.SetProperty (DIVX_FILMEFFECT_ID, IntToStr (tbrFilmEffect.Position));
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.btnDeactivateClick(Sender: TObject);
//------------------------------------------------------------------------------
begin
   PropertyPageSaver.SaveProperties;
   PropertyPageSaver.Deactivate;
   btnActivate.Enabled := True;
   btnDialog.Enabled := False;
   btnDeActivate.Enabled := False;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.btnShowGlobalClick(Sender: TObject);
//------------------------------------------------------------------------------
var
   pUnk: IUnknown;
begin
   if CoCreateInstance (CLSID_DIVX, nil, CLSCTX_INPROC_SERVER or CLSCTX_LOCAL_SERVER, IUnknown, pUnk) = S_OK then begin
      if PropertyPageSaver.Activate (pUnk) then begin  // if the dialog has been sucessfully activated
         mmoResults.Text := PropertyPageSaver.GetPropertiesState;
         mmoResults.Lines.Add ('');
         PropertyPageSaver.Deactivate;                 // and finally we deactivate the dialog
      end;
      pUnk := nil;
   end;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.btnShowIdentificationClick(Sender: TObject);
//------------------------------------------------------------------------------
var
   pUnk: IUnknown;
begin
   if CoCreateInstance (CLSID_DIVX, nil, CLSCTX_INPROC_SERVER or CLSCTX_LOCAL_SERVER, IUnknown, pUnk) = S_OK then begin
      if PropertyPageSaver.Activate (pUnk) then begin
         PropertyPageSaver.IdentifyProperties := True; // to show the "IDENTIFY" tab in the dialog
         PropertyPageSaver.ShowDialog;
      end;
      pUnk := nil;
   end;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.PropertyPageSaverPropertiesRestored(Sender: TObject);
//------------------------------------------------------------------------------
begin
   StatusBar1.SimpleText := 'Properties restored from: ' + PropertyPageSaver.GetFullRegistryPath;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.PropertyPageSaverPropertiesSaved(Sender: TObject);
//------------------------------------------------------------------------------
begin
   StatusBar1.SimpleText := 'Properties saved at: ' + PropertyPageSaver.GetFullRegistryPath;
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.TabSheet3Show(Sender: TObject);
//------------------------------------------------------------------------------
begin
   tbrFilmEffect.Position := StrToIntDef (PropertyPageSaver.GetProperty (DIVX_FILMEFFECT_ID), 0);
end;

//------------------------------------------------------------------------------
procedure TfrmDemo.PropertyPageSaverNewPropertyValue(Sender: TObject;
  PropertyId, PropertyValue, PropertyLabel: String);
//------------------------------------------------------------------------------
begin
   if not PropertyPageSaver.IdentifyProperties then begin
      mmoResults.lines.Add (PropertyId + ' = ' + PropertyValue  + '  (' + PropertyLabel + ')');
   end;
end;


end.
